//=============================================================================
// WeaponC4.
//=============================================================================
class WeaponC4 extends DeusExWeapon;

var localized String shortName;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if (Level.NetMode != NM_Standalone)
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot <= 9);
}

defaultproperties
{
     ShortName="C4"
     LowAmmoWaterMark=2
     FireSound=Sound'DeusExSounds.Weapons.CrowbarFire'
     GoverningSkill=Class'DeusEx.SkillDemolition'
     EnviroEffective=ENVEFF_AirWater
     Concealability=CONC_All
     ShotTime=0.500000
     reloadTime=0.100000
     HitDamage=50
     maxRange=4800
     bHandToHand=True
     AccurateRange=2400
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     mpReloadTime=0.100000
     mpHitDamage=50
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     AmmoName=Class'MSC41_1.AmmoC4'
     ReloadCount=1
     PickupAmmoCount=5
     bWarnTarget=True
     FireOffset=(Y=10.000000,Z=20.000000)
     ProjectileClass=Class'MSC41_1.C4'
     shakemag=50.000000
     SelectSound=Sound'DeusExSounds.Weapons.LAMSelect'
     InventoryGroup=240
     ItemName="C4 Plastic Explosive"
     PlayerViewOffset=(X=24.000000,Y=-15.000000,Z=-17.000000)
     PlayerViewMesh=LodMesh'DeusExItems.LAM'
     PickupViewMesh=LodMesh'DeusExItems.LAMPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.LAM3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconLAM'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLAM'
     largeIconWidth=35
     largeIconHeight=45
     Description="A multi-functional explosive with electronic priming system that can either be thrown or attached to any surface with its polyhesive backing and used as a proximity mine or as a remote explosive.|n|n<UNATCO OPS FILE NOTE SC093-BLUE> Disarming a proximity device should only be attempted with the proper demolitions training. Trust me on this. -- Sam Carter <END NOTE>"
     beltDescription="|cf88 C4"
     Mesh=LodMesh'DeusExItems.LAMPickup'
     CollisionRadius=3.800000
     CollisionHeight=3.500000
     Mass=5.000000
     Buoyancy=2.000000
}
